#ifndef CPP_ENROLL_SIGNATURE_INFO_H_
#define CPP_ENROLL_SIGNATURE_INFO_H_

#include "cppcades.h"
#include <atlcrypt2.h>
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollX509SignatureInformation
{
public:
    CPPEnrollX509SignatureInformation(void);
    CPPEnrollX509SignatureInformation(LPCSTR hashAlgorithm, LPCSTR publicKeyAlgorithm);
    ~CPPEnrollX509SignatureInformation(void);
    HRESULT get_HashAlgorithm(boost::shared_ptr<CPPEnrollObjectId>& pVal);
    HRESULT put_HashAlgorithm(boost::shared_ptr<CPPEnrollObjectId>& newVal);

    HRESULT get_PublicKeyAlgorithm(boost::shared_ptr<CPPEnrollObjectId>& pVal);
    HRESULT put_PublicKeyAlgorithm(boost::shared_ptr<CPPEnrollObjectId>& newVal);
    
    HRESULT GetSignatureAlgorithm(bool Pkcs7Signature, bool SignatureKey,
        boost::shared_ptr<CPPEnrollObjectId>& pVal);

    // internal use
    LPCSTR get_pszSignatureOID();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollX509SignatureInformation);
    HRESULT CheckInitialized();
    boost::shared_ptr<CPPEnrollObjectId> m_pHashAlgorithm;
    boost::shared_ptr<CPPEnrollObjectId> m_pPublicKeyAlgorithm;
    boost::shared_ptr<CPPEnrollObjectId> m_pSignatureAlgorithm;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_SIGNATURE_INFO_H_
