#ifndef CPP_ENROLL_READER_OBJECT_H_
#define CPP_ENROLL_READER_OBJECT_H_

#include "cppcades.h"
#include <atlcrypt2.h>

using namespace ATL;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollReaderMode
{
public:
    CPPEnrollReaderMode(void);
    ~CPPEnrollReaderMode(void);
    void CheckInitialized();
    HRESULT Initialize(CAtlString sNickName, CAtlString sName, CAtlString sMedia, BYTE carrierFlags);
    HRESULT get_NickName(CAtlString& pVal);
    HRESULT get_Name(CAtlString& pVal);
    HRESULT get_Media(CAtlString& pVal);
    HRESULT get_CarrierFlags(unsigned int& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollReaderMode);
    bool m_bInitialized;
	CAtlString m_sNickName;
	CAtlString m_sName;
	CAtlString m_sMedia;
	BYTE m_carrierFlags;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_READER_OBJECT_H_
