#ifndef CPP_ENROLL_POLICY_QUALIFIER_OBJECT_H_
#define CPP_ENROLL_POLICY_QUALIFIER_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollEnumerations.h"
#include "CPPEnrollObjectId.h"
#include <atlcrypt2.h>

using namespace ATL;
namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollPolicyQualifier
{
public:
    CPPEnrollPolicyQualifier(void);
    ~CPPEnrollPolicyQualifier(void);
    // 
    HRESULT InitializeEncode(CAtlString& strName, PolicyQualifierType QualifierType);

    HRESULT get_ObjectId(boost::shared_ptr<CPPEnrollObjectId>& pObjectId);
    HRESULT get_Qualifier(CAtlString& pVal);
    HRESULT get_RawData(EncodingType encodingType, CAtlString& pVal);
    HRESULT get_Type(PolicyQualifierType& QualifierType);

    // internal use

private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollPolicyQualifier);
    boost::shared_ptr<CPPEnrollObjectId> m_pOid;
    CAtlStringA m_strQualifier;
    PolicyQualifierType m_QualifierType;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_POLICY_QUALIFIER_OBJECT_H_
