#ifndef CPP_ENROLL_CSP_STATUS_OBJECT_H_
#define CPP_ENROLL_CSP_STATUS_OBJECT_H_

#include "cppcades.h"
#include "CPPEnrollCspAlgorithm.h"
#include "CPPEnrollCspInformation.h"

using namespace ATL;

namespace CryptoPro {
namespace PKI {
namespace Enroll {

class CPPEnrollCspInformation;

class CPPEnrollCspStatus
{
public:
    CPPEnrollCspStatus(void);
    ~CPPEnrollCspStatus(void);
    HRESULT Initialize(boost::shared_ptr<CPPEnrollCspInformation>& pCsp,
        boost::shared_ptr<CPPEnrollCspAlgorithm>& pAlgorithm);
    HRESULT get_CspAlgorithm(boost::shared_ptr<CPPEnrollCspAlgorithm>& pVal);
    HRESULT get_CspInformation(boost::shared_ptr<CPPEnrollCspInformation>& pVal);
private:
    DISALLOW_COPY_AND_ASSIGN(CPPEnrollCspStatus);
    void CheckInitialized();
    bool m_bInitialized;
    boost::shared_ptr<CPPEnrollCspAlgorithm> m_pAlgorithm;
    boost::shared_ptr<CPPEnrollCspInformation> m_pCspInformation;
};

} /* namespace Enroll */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_ENROLL_CSP_STATUS_OBJECT_H_
