#ifndef CPP_PRIVATE_KEY_USAGE_VALIDATOR_OBJECT_H_
#define CPP_PRIVATE_KEY_USAGE_VALIDATOR_OBJECT_H_

#include "cppcades.h"
#include "CPPVersion.h"
#include "CPPCadesCPChain.h"
#ifdef _WIN32
#include <ATLComTime.h>
#endif // _WIN32
#include "PrivateKeyUsageValidatorImpl.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesPrivateKeyUsageValidatorObject
{
public:
    CPPCadesPrivateKeyUsageValidatorObject(void);
    ~CPPCadesPrivateKeyUsageValidatorObject(void);

    HRESULT IsChainValid(CPPCadesCPChainObject chain, BOOL* value);
    HRESULT IsCertValidNow(boost::shared_ptr<CPPCadesCPCertificateObject>& pCert, bool* value);
    HRESULT IsCertValidOnTime(boost::shared_ptr<CPPCadesCPCertificateObject>& pCert, CDateTime dateTime, bool* value);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesPrivateKeyUsageValidatorObject);
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPP_PRIVATE_KEY_USAGE_VALIDATOR_OBJECT_H_
