#ifndef CPPCADES_IDENTITY_CARD_H_
#define CPPCADES_IDENTITY_CARD_H_
#include "cppcades.h"
#include "UECInternal.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesIdentityCardObject
{
public:
    CPPCadesIdentityCardObject();
    ~CPPCadesIdentityCardObject();

    HRESULT get_ContainerType(CAtlString& pVal);
    HRESULT set_ContainerType(const CAtlString& newVal);
    HRESULT get_DivisionCode(CAtlString& pVal);
    HRESULT set_DivisionCode(const CAtlString& newVal);
    HRESULT get_DivisionName(CAtlString& pVal);
    HRESULT set_DivisionName(const CAtlString& newVal);
    HRESULT get_EffectiveDate(CAtlString& pVal);
    HRESULT set_EffectiveDate(const CAtlString& newVal);
    HRESULT get_ExpirationDate(CAtlString& pVal);
    HRESULT set_ExpirationDate(const CAtlString& newVal);
    HRESULT get_IdExtension(CAtlString& pVal);
    HRESULT set_IdExtension(const CAtlString& newVal);
    HRESULT get_IdNumber(CAtlString& pVal);
    HRESULT set_IdNumber(const CAtlString& newVal);
    HRESULT get_IdSeries(CAtlString& pVal);
    HRESULT set_IdSeries(const CAtlString& newVal);

    // internal use
    HRESULT InitFromEncodedData(const ATL2::CStringBlob& encData, bool isTrusted);
    HRESULT GetEncodedData(ATL2::CStringBlob& encData);
    HRESULT Clear();
private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesIdentityCardObject);
    bool m_isTrusted;
    IDENTITY_CARD_DATA m_data;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif //CPPCADES_IDENTITY_CARD_H_
