#ifndef CPPCADES_CP_STORE_OBJECT_H_
#define CPPCADES_CP_STORE_OBJECT_H_
#include "cppcades.h"
#include "cplib/Blob.h"
#include "CPPCadesCPCertificates.h"
#include "CPPCadesCPCRL.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPCertificatesObject;

class CPPCadesCPStoreObject
{
public:
    CPPCadesCPStoreObject();
    ~CPPCadesCPStoreObject();

    HRESULT Open(CADESCOM_STORE_LOCATION location, const wchar_t *name, CAPICOM_STORE_OPEN_MODE& mode);
    HRESULT Import(CryptoPro::CBlob& encStore);
    HRESULT Close();
    HRESULT Add(boost::shared_ptr<CPPCadesCPCertificateObject> pVal);
    HRESULT AddCRL(boost::shared_ptr<CPPCadesCPCRLObject> pVal);
    HRESULT Remove(boost::shared_ptr<CPPCadesCPCertificateObject> pVal);
    HRESULT Export(DWORD SaveAs, DWORD EncodingType, CryptoPro::CBlob& encStore);

    HRESULT get_Certificates(boost::shared_ptr<CPPCadesCPCertificatesObject>& pVal);
    HRESULT get_Location(CADESCOM_STORE_LOCATION* location);
    HRESULT get_Name(CAtlString& name);

    //    (CADES-1810)
    HRESULT get_NextCertificate(boost::shared_ptr<CPPCadesCPCertificateObject>& pVal, 
        boost::shared_ptr<CPPCadesCPCertificatesObject>& pCollVal);
    HCERTSTORE get_Handle();

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPStoreObject);

    CADESCOM_STORE_LOCATION m_location;
    CAPICOM_STORE_OPEN_MODE m_mode;
    CCertStore m_store;
    CAtlString m_name;

    PCCERT_CONTEXT m_pPrevCert;
    CCertStore m_resultStore;
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_STORE_OBJECT_H_


