#ifndef CPPCADES_CP_CERTIFICATES_OBJECT_H_
#define CPPCADES_CP_CERTIFICATES_OBJECT_H_

#include "cppcades.h"
#include <atlcrypt2.h>
#include "cplib/DateTime.h"
#include "CPPCadesCPCertificate.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPCertificateObject;

#define FIND_CRITERIA_DWORD  0x0
#define FIND_CRITERIA_DATE   0x1
#define FIND_CRITERIA_STRING 0x2

struct FindCriteria
{
    DWORD dwCriteriaFlag;
    CDateTime date;
    DWORD dword;
    CAtlString str;
};

class CPPCadesCPCertificatesObject
{
public:
    CPPCadesCPCertificatesObject();
    ~CPPCadesCPCertificatesObject();


    HRESULT Find(CAPICOM_CERTIFICATE_FIND_TYPE& findType,
        FindCriteria* varCriteria, BOOL& bFindOnly,
        boost::shared_ptr<CPPCadesCPCertificatesObject>& pVal);
    HRESULT Item(unsigned int index, boost::shared_ptr<CPPCadesCPCertificateObject>& pVal);
    HRESULT Count(unsigned int* count);
    HRESULT Clear();

    //internal use
    HRESULT GetStoreHandle(CCertStore& store);
    HRESULT Add(CCertContext& certificate);
    HRESULT Assign(ATL2::CCertStore* value);
    HRESULT AddAlways(PCCERT_CONTEXT pCtx);
    HRESULT FindImpl(CAPICOM_CERTIFICATE_FIND_TYPE& findType,
        FindCriteria* varCriteria, boost::shared_ptr<CPPCadesCPCertificatesObject>& pVal,
        BOOL& bFindValidOnly);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPCertificatesObject);
#ifndef UNIX
#pragma warning(push)
#pragma warning(disable: 4251)
#endif
    CCertStore m_certstore;
#ifndef UNIX
#pragma warning(pop)
#endif
};

} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_CERTIFICATES_OBJECT_H_


