#ifndef CPPCADES_CP_CERTIFICATESTATUS_OBJECT_H_
#define CPPCADES_CP_CERTIFICATESTATUS_OBJECT_H_

#include "cppcades.h"
#include "CPPCadesCollections.h"
#include "CPPCadesCPCertificates.h"

namespace CryptoPro {
namespace PKI {
namespace CAdES {

class CPPCadesCPCertificatesObject;

class CPPCadesCPCertificateStatusObject
{
public:
    CPPCadesCPCertificateStatusObject();
    ~CPPCadesCPCertificateStatusObject();

    HRESULT get_Result(BOOL *pVal);
    HRESULT get_CheckFlag(CAPICOM_CHECK_FLAG *pVal);
    HRESULT put_CheckFlag(CAPICOM_CHECK_FLAG pVal);
    HRESULT EKU(boost::shared_ptr<CPPCadesCPEKUObject>& pVal);
    HRESULT get_VerificationTime(CDateTime& pVal);
    HRESULT put_VerificationTime(CDateTime pVal);
    HRESULT get_UrlRetrievalTimeout(long *pVal);
    HRESULT put_UrlRetrievalTimeout(long pVal);
    HRESULT CertificatePolicies(boost::shared_ptr<CPPCadesCPOIDsObject>& pVal);
    HRESULT ApplicationPolicies(boost::shared_ptr<CPPCadesCPOIDsObject>& pVal);
    HRESULT get_ValidationCertificates(boost::shared_ptr<CPPCadesCPCertificatesObject>& pVal);
    HRESULT put_ValidationCertificates(boost::shared_ptr<CPPCadesCPCertificatesObject>& pVal);
    HRESULT get_ErrorStatuses(boost::shared_ptr<CPPCadesCPErrorStatusesObject>& pVal);
    HRESULT put_ErrorStatuses(boost::shared_ptr<CPPCadesCPErrorStatusesObject>& pVal);

    //internal use
    HRESULT put_Result(BOOL pVal);

private:
    DISALLOW_COPY_AND_ASSIGN(CPPCadesCPCertificateStatusObject);

    BOOL m_result;
    CAPICOM_CHECK_FLAG m_checkFlag;
    long m_urlRetrievalTimeout;
    CDateTime m_verificationTime;
    bool m_isVerificationTimeSet;

    //      ,    -   
    boost::shared_ptr<CPPCadesCPEKUObject> m_pEKU;
    boost::shared_ptr<CPPCadesCPOIDsObject> m_pCertPolicies;
    boost::shared_ptr<CPPCadesCPOIDsObject> m_pAppPolicies;
    boost::shared_ptr<CPPCadesCPCertificatesObject> m_pCerts;
    boost::shared_ptr<CPPCadesCPErrorStatusesObject> m_pErrorStatuses;
};
} /* namespace CAdES */
} /* namespace PKI */
} /* namespace CryptoPro */

#endif // CPPCADES_CP_CERTIFICATESTATUS_OBJECT_H_

