<?xml version="1.0" encoding="windows-1251"?>
 <xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		 xmlns:cp="localhost"
 		 xmlns:fo="http://www.w3.org/1999/XSL/Format"
 		 version='1.0'>


<xsl:template match="Signature" name="Signature">

	<!--    -->
  <fo:block font-family="Times" font-size="10pt"				
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Signature_header</xsl:with-param> </xsl:call-template>                                      <!--  -->
  </fo:block>
  <fo:block font-family="Courier New" font-size="10pt"                              
	    border-style="solid"
	    padding="3pt"
	    >

    <xsl:call-template name="split">
      <xsl:with-param name="val">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
  </fo:block>
</xsl:template>

<xsl:template name="AlgorithmIdentifier" match="AlgorithmIdentifier">


  <xsl:for-each select="./algorithm">  
    <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                       
	    padding="3pt"
	    >
    <xsl:call-template name="printOID"/>
    <xsl:apply-templates select="./parameters/*"/>

    </fo:block>
  </xsl:for-each>
</xsl:template>


<xsl:template name="Version" match="Version">

    <!--   -->	
  <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Version_header</xsl:with-param> </xsl:call-template>			<!--  -->
  </fo:block>

         <!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	<xsl:value-of select='name(./*)'/>
  </fo:block>



</xsl:template>




<xsl:template name="CertificateSerialNumber" match="CertificateSerialNumber">
	<!--   : -->
  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertificateSerialNumber_header</xsl:with-param> </xsl:call-template>					<!--  -->
  </fo:block>

    <!--    -->	
  <fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >

    <xsl:value-of select="."/>
   </fo:block>
</xsl:template>


    <!--   -->
<xsl:template name="Name" match="Name">
    <!--    -->
     <xsl:for-each select="./rdnSequence">  
	<xsl:call-template name="RNDSequence"/>
     </xsl:for-each>
</xsl:template>


                  <!--    -->
<xsl:template name="RNDSequence" match="RNDSequence">
    <xsl:for-each select="./*">
        <!--    -->
        <xsl:sort select="position()" data-type="number" order="descending"/>
		<!--   RelativeDistinguishedName -->
		<xsl:variable name="name">
		    <xsl:call-template name="RelativeDistinguishedName"/>
		</xsl:variable>

	    <xsl:if test="position() != last()">
		 <xsl:value-of select="concat($name,', ')"/>
	    </xsl:if>

	    <xsl:if test="position() = last()">
		    <xsl:value-of select="$name"/>
	    </xsl:if>

    </xsl:for-each>
</xsl:template>


 <!--    -->
<xsl:template name="RelativeDistinguishedName" match="RelativeDistinguishedName">

    <!--     -->
   <xsl:variable name="result">
     <xsl:for-each select="./*">  
        <xsl:if test="position() != 1">+</xsl:if>
	<xsl:call-template name="AttributeTypeAndValue"/>
     </xsl:for-each>
   </xsl:variable>
   <xsl:value-of select="$result"/>

<!--    <xsl:call-template name="split">
      <xsl:with-param name="val" select="$result"/>
    </xsl:call-template>
-->
</xsl:template>



     <!-- IssuerSignTool -->
<xsl:template name="IssuerSignTool" match="IssuerSignTool">

  <fo:block keep-with-next="always">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_signTool_name</xsl:with-param> </xsl:call-template>
     <xsl:for-each select="./signTool">  
	<xsl:value-of select="."/>
     </xsl:for-each>
  </fo:block>
  <fo:block keep-with-next="always" >
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_signToolCert_name</xsl:with-param> </xsl:call-template>
     <xsl:for-each select="./signToolCert">  
       <xsl:value-of select="."/>
     </xsl:for-each>
  </fo:block>
  <fo:block keep-with-next="always" >
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_cATool_name</xsl:with-param> </xsl:call-template>
     <xsl:for-each select="./cATool">  
       <xsl:value-of select="."/>
     </xsl:for-each>
  </fo:block>
  <fo:block keep-with-next="always">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_cAToolCert_name</xsl:with-param> </xsl:call-template>
     <xsl:for-each select="./cAToolCert">  
       <xsl:value-of select="."/>
     </xsl:for-each>
  </fo:block>
</xsl:template>


     <!-- IdentificationKind -->
<xsl:template name="IdentificationKind" match="IdentificationKind">

  <fo:block keep-with-next="always">
     <xsl:for-each select="./personal">  
        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_identificationKind_personal_name</xsl:with-param> </xsl:call-template>
     </xsl:for-each>
     <xsl:for-each select="./remote_cert">  
        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_identificationKind_remotecert_name</xsl:with-param> </xsl:call-template>
     </xsl:for-each>
     <xsl:for-each select="./remote_passport">  
        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_identificationKind_remotepassport_name</xsl:with-param> </xsl:call-template>
     </xsl:for-each>
     <xsl:for-each select="./remote_system">  
        <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_identificationKind_remotesystem_name</xsl:with-param> </xsl:call-template>
     </xsl:for-each>
  </fo:block>
</xsl:template>

     <!--   -->
<xsl:template name="Validity" match="Validity">

  <fo:block font-family="Times" font-size="10pt"
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"                 	
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Validity_notBefore</xsl:with-param> </xsl:call-template>               <!--  -->
  </fo:block>

	<!--    -->
    <fo:block font-family="Courier New" font-size="10pt"
	      border-style="solid"                      
	      padding="3pt"
	      >

     <xsl:for-each select="./notBefore">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>


    </fo:block>

	<!--   -->	                        
    <fo:block font-family="Times" font-size="10pt"
	      space-before="4pt"
	      space-after="2pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Validity_notAfter</xsl:with-param> </xsl:call-template>		<!--  -->
    </fo:block>

	<!--    -->
    <fo:block font-family="Courier New" font-size="10pt"
	      border-style="solid"
	      padding="3pt"				
	      >
     <xsl:for-each select="./notAfter">  
	<xsl:call-template name="Time"/>
    </xsl:for-each>

    </fo:block>


</xsl:template>





	<!--    -->
<xsl:template name="UniqueIdentifier" match="UniqueIdentifier">

    <xsl:call-template name="split">
      <xsl:with-param name="val">
	<xsl:value-of select="."/>
      </xsl:with-param>
    </xsl:call-template>
</xsl:template>


	<!--      -->
<xsl:template name="SubjectPublicKeyInfo" match="SubjectPublicKeyInfo">

	<!--     -->
  <fo:block font-family="Times" font-size="10pt"
	    space-before="6pt"
	    space-after="3pt"                		
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SubjectPublicKeyInfo_header</xsl:with-param> </xsl:call-template>                <!--  -->
  </fo:block>


	<!--    -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="4pt"
	      space-after="2pt"                        
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SubjectPublicKeyInfo_algorithm</xsl:with-param> </xsl:call-template>		<!--  -->
    </fo:block>
	
	<!--     -->	
    <fo:block font-family="Courier New" font-size="10pt"    
	      padding="3pt"
	      >
     <xsl:for-each select="./algorithm">  
	<xsl:call-template name="AlgorithmIdentifier"/>
    </xsl:for-each>
    </fo:block>



	<!--     -->
    <fo:block font-family="Times" font-size="10pt"
	      space-before="4pt"
	      space-after="2pt"                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SubjectPublicKeyInfo_subjectPublicKey</xsl:with-param> </xsl:call-template>    	<!--  -->
    </fo:block>


		<!--   -->
      <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >

      <xsl:call-template name="split"> 	
	<xsl:with-param name="val">
	  <xsl:value-of select="subjectPublicKey"/>     
	</xsl:with-param>
      </xsl:call-template>
  </fo:block>

</xsl:template>

<!--     -->
<xsl:template match="DigestParamSet" name="DigestParamSet">

	<!--   -: -->
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestParamSet_header</xsl:with-param> </xsl:call-template>                             <!--  -->
  </fo:block>
  <fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >
    <xsl:call-template name="printOID"/>
  </fo:block>
</xsl:template>


	<!--   -->

<xsl:template match="EncryptionParamSet" name="EncryptionParamSet">

         <!--   : -->
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_EncryptionParamSet_header</xsl:with-param> </xsl:call-template>                             <!--  -->
  </fo:block>

	<!--    -->
  <fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >
    <xsl:call-template name="printOID"/>
  </fo:block>
</xsl:template>


<!--     -->
<xsl:template match="PublicKeyParamSet" name="PublicKeyParamSet">
	<!--    : -->
  <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0" 
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PublicKeyParamSet_header</xsl:with-param> </xsl:call-template>              <!--  -->
  </fo:block>

	<!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                       
	    padding="3pt"
	    >
    <xsl:call-template name="printOID"/>               <!--  OID` -->
  </fo:block>
</xsl:template>








<xsl:template match="AuthorityInfoAccessSyntax" name="AuthorityInfoAccessSyntax">

   <xsl:for-each select="AccessDescription">
     <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_AccessMethod</xsl:with-param> </xsl:call-template>
    <xsl:for-each select="./accessMethod">  
	<xsl:call-template name="printOID"/>
    </xsl:for-each>
    <xsl:for-each select="./accessLocation">  
        <fo:block>
	<xsl:call-template name="GeneralName"/>
        </fo:block>
    </xsl:for-each>
   </xsl:for-each>
   
</xsl:template>




<xsl:template match="ContentTypeIdentifier" name="ContentTypeIdentifier">
     <xsl:call-template name="printOID"/>
</xsl:template>


<xsl:template match="GeneralName" name="GeneralName">
   <xsl:apply-templates/>
</xsl:template>


<xsl:template match="Attribute" name="Attribute">

  <xsl:variable name="attributeCount" select="$attributeCount + 1"/>

	<!--  L  --> 
  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
     <xsl:for-each select="./type">  
	<xsl:call-template name="printOID"/>
    </xsl:for-each>

  </fo:block>

	<!--    -->

  <fo:block font-family="Courier New" font-size="10pt"			
	    padding="3pt"
	    >
<!--	    border-style="solid" -->

    <xsl:choose>
      <xsl:when test='values/*'>
	<xsl:apply-templates select="values/*"/>                        <!--   -->
      </xsl:when>
      <xsl:otherwise>
	<xsl:call-template name="split">
	  <xsl:with-param name="val">
	    <xsl:value-of select="values"/>
	  </xsl:with-param>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>

  </fo:block>
</xsl:template>



<!--    : :  -->
<xsl:template match="ProofOfPossession" name="ProofOfPossession">

  <fo:block font-family="Times" font-size="10pt"                
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	<!--    : :  -->	
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ProofOfPossession_header</xsl:with-param> </xsl:call-template>			<!--  -->
  </fo:block>
  <fo:block font-family="Courier New" font-size="10pt"              
	    border-style="solid"
	    padding="3pt"
	    >
  <xsl:choose>
	<!--   :  -->
    <xsl:when test="count(raVerified) &gt; 0">
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_checked_by</xsl:with-param> </xsl:call-template>			<!--  -->
    </xsl:when>

    <xsl:when test="count(signature) &gt; 0">
        <xsl:for-each select="./signature">  
	   <xsl:call-template name="POPOSigningKey"/>			<!--  -->
	</xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="."/>
    </xsl:otherwise>
  </xsl:choose>
  </fo:block>
</xsl:template>


<xsl:template match="POPOSigningKey" name="POPOSigningKey">

	<!-- :-->

     <xsl:for-each select="./algorithmIdentifier">  
	<xsl:call-template name="SignatureAlgorithm"/>
    </xsl:for-each>



	<!--   -->
     <xsl:for-each select="./signature">  
	<xsl:call-template name="Signature"/>
    </xsl:for-each>
</xsl:template>


<xsl:template name="CertId" match="CertId">

	<!-- -->

  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertId_issuer</xsl:with-param> </xsl:call-template>
  </fo:block>

	<!--   -->
     <xsl:for-each select="./issuer">  
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:call-template name="GeneralName"/>
	</fo:block>
    </xsl:for-each>

	<xsl:for-each select="serialNumber">
		<xsl:call-template name="CertificateSerialNumber"/>
	</xsl:for-each>
</xsl:template>


<xsl:template name="TSAPolicyId" match="TSAPolicyId">
	    
    <!--   -->	
  <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_TSAPolicyId</xsl:with-param> </xsl:call-template>
  </fo:block>

         <!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	    <xsl:call-template name="printOID"/>	
  </fo:block>

</xsl:template>




        <!--   -->
<xsl:template match="MessageImprint" name="MessageImprint">

        
        <!--    -->

	<!--    -->
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

		<!-- -->
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_MessageImprint_hashAlgorithm</xsl:with-param> </xsl:call-template>					<!--  -->
	</fo:block>

	<fo:block>
           <xsl:for-each select="./hashAlgorithm">  
  	      <xsl:call-template name="AlgorithmIdentifier"/>
           </xsl:for-each>
	</fo:block>

	<!--   -->

	<fo:block font-family="Times" font-size="10pt"
	      space-before="4pt"
	      space-after="2pt"                         
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_MessageImprint_hashedMessage</xsl:with-param> </xsl:call-template>
	</fo:block>

	  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
    	    <xsl:value-of select="hashedMessage"/>                                      <!--  -->

        </fo:block>
</xsl:template>




<xsl:template match="Nonce" name="Nonce">

        <!--   -->
  <fo:block font-family="Times" font-size="10pt" 			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Nonce</xsl:with-param> </xsl:call-template>						<!--  -->
  </fo:block>

	<!--  -->
  <fo:block font-family="Courier New" font-size="10pt"                      
	    border-style="solid"
	    padding="3pt"
	    >
       	    <xsl:value-of select="."/>                                      		<!--  -->
  </fo:block>

</xsl:template>


<xsl:template match="SignerInfos" name="SignerInfos">

    <fo:block font-family="Courier New" font-size="14pt"
	    space-before="32pt"			
	    space-after="16pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    text-align="center"
            keep-with-next="always"
	    >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignerInfos_header</xsl:with-param> </xsl:call-template>

    </fo:block>	

       <xsl:for-each select="./*">  
  	 <xsl:call-template name="SignerInfo"/>	
       </xsl:for-each>

</xsl:template>
	
<xsl:template match="SignerInfo" name="SignerInfo">

    <!--   -->	
    <xsl:for-each select="./version">  
	    <!--   -->	
	<fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignerInfo_version</xsl:with-param> </xsl:call-template>	
	</fo:block>

         <!--   -->
	<fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	    <xsl:value-of select='name(./*)'/>
	</fo:block>
    </xsl:for-each>


    <xsl:for-each select="./sid">  
	<xsl:call-template name="SignerIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./digestAlgorithm">  
	<xsl:call-template name="DigestAlgorithmIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./signedAttrs">  
	<xsl:call-template name="SignedAttributes"/>
    </xsl:for-each>

    <xsl:for-each select="./signatureAlgorithm">  
	<xsl:call-template name="SignatureAlgorithmIdentifier"/>
    </xsl:for-each>

    <xsl:for-each select="./signature">  
	<xsl:call-template name="SignatureValue"/>
    </xsl:for-each>

    <xsl:for-each select="./unsignedAttrs">  
	<xsl:call-template name="UnsignedAttributes"/>
    </xsl:for-each>

</xsl:template>

<xsl:template match="SignerIdentifier" name="SignerIdentifier">

  <fo:block font-family="Times" font-size="10pt"                                
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignerIdentifier_header</xsl:with-param> </xsl:call-template>		
   </fo:block>

  <fo:block font-family="Times" font-size="10pt"                                
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    border-style="solid"                        
	    padding="3pt"
	    keep-with-next="always"
	    >

    <xsl:for-each select="./issuerAndSerialNumber">  
	<xsl:call-template name="IssuerAndSerialNumber"/>
    </xsl:for-each>

    <xsl:for-each select="./subjectKeyIdentifier">  
	<xsl:call-template name="SubjectKeyIdentifier"/>
    </xsl:for-each>
   </fo:block>

</xsl:template>





<xsl:template match="IssuerAndSerialNumber" name="IssuerAndSerialNumber">
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuerAndSerialNumber_issuer</xsl:with-param> </xsl:call-template>		<!--  --> 	
	<!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
    border-style="solid"
    padding="3pt"
    >
    <xsl:for-each select="./issuer">  
	<xsl:call-template name="Name"/>
    </xsl:for-each>
   </fo:block>

    <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="CertificateSerialNumber"/>
    </xsl:for-each>


</xsl:template>





<xsl:template match="SignedAttributes" name="SignedAttributes">
    <fo:block font-family="Courier New" font-size="10pt"
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
            keep-with-next="always"
	    >
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignedAttributes_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block  font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    padding="3pt"
	    >
      <xsl:for-each select="./*">  
	<xsl:call-template name="Attribute"/>
      </xsl:for-each>
    </fo:block>

</xsl:template>


<xsl:template match="SignatureAlgorithmIdentifier" name="SignatureAlgorithmIdentifier">
    <fo:block font-family="Courier New" font-size="10pt"
	    padding="3pt"
            keep-with-next="always"
	    >
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureAlgorithmIdentifier_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block font-family="Courier New" font-size="10pt"
	    padding="3pt"
	    >
	<xsl:call-template name="AlgorithmIdentifier"/>
   </fo:block>
</xsl:template>


<xsl:template match="SignatureValue" name="SignatureValue">
    <fo:block font-family="Courier New" font-size="10pt"
	    padding="3pt"
            keep-with-next="always"
	    >
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureValue_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	    <xsl:call-template name="split">
	      <xsl:with-param name="val">
		<xsl:value-of select="."/>
	      </xsl:with-param>
	    </xsl:call-template>

   </fo:block>
</xsl:template>


<xsl:template match="UnsignedAttributes" name="UnsignedAttributes">
    <fo:block>
    <fo:block font-family="Courier New" font-size="10pt"
	    keep-with-next="always"
	    padding="3pt"
	    >
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_UnsignedAttributes_header</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block>
<!--    <fo:block border-style="solid">-->
      <xsl:for-each select="./*">  
	<xsl:call-template name="Attribute"/>
      </xsl:for-each>
    </fo:block>
   </fo:block>
</xsl:template>



<xsl:template match="DigestAlgorithmIdentifiers" name="DigestAlgorithmIdentifiers">
    <fo:block font-family="Courier New" font-size="10pt"
	    padding="3pt"
	    >
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestAlgorithmIdentifiers_header</xsl:with-param> </xsl:call-template>
    </fo:block>
    <xsl:for-each select="./*">  
	<xsl:call-template name="DigestAlgorithmIdentifier"/>	
    </xsl:for-each>
</xsl:template>




<xsl:template match="DigestAlgorithmIdentifier" name="DigestAlgorithmIdentifier">
    <fo:block font-family="Courier New" font-size="10pt"
	    padding="3pt"
            keep-with-next="always"
	    >
	 <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_DigestAlgorithmIdentifier_header</xsl:with-param> </xsl:call-template>
    </fo:block>
    <fo:block>
	<xsl:call-template name="AlgorithmIdentifier"/>	
    </fo:block>
</xsl:template>




	<!--    -->	
<xsl:template match="Accuracy" name="Accuracy">

	<!-->   <-->
    <fo:block text-align="left"
	      font-family="Arial" font-size="10pt"
	      space-before="4pt"			
	      space-after="2pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      keep-with-next="always"
	      >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_header</xsl:with-param> </xsl:call-template>
    </fo:block>


	<!--><-->
    <fo:block text-align="left"
	      font-family="Arial" font-size="10pt"
	      space-before="4pt"			
	      space-after="2pt"
	      space-before.precedence="0"
	      space-after.precedence="3"
	      padding="3pt"
	      border-style="solid"
	      >
	
	<xsl:for-each select="./seconds">      
		<xsl:value-of select="."/>  
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_seconds</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

	<xsl:for-each select="./millis">      
		<xsl:value-of select="."/>      
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_millis</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

	<xsl:for-each select="./micros">      
		<xsl:value-of select="."/>      
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Accuracy_micros</xsl:with-param> </xsl:call-template>
	</xsl:for-each>  

    </fo:block>

</xsl:template>


	<!--    -->
<xsl:template match="SignatureAlgorithm" name="SignatureAlgorithm">

    <!--    -->
    <fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

	<!-- :-->
      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SignatureAlgorithm_header</xsl:with-param> </xsl:call-template>
    </fo:block>


     <xsl:for-each select=".">  
	<xsl:call-template name="AlgorithmIdentifier"/>
    </xsl:for-each>

</xsl:template>

<xsl:template match="UnauthAttributes" name="UnauthAttributes">
  <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_UnauthAttributes_header</xsl:with-param> </xsl:call-template>			
  </fo:block>

  <fo:block border-style="solid">
     <xsl:for-each select="./*">  
	<xsl:call-template name="Attribute"/>
    </xsl:for-each>
  </fo:block>

</xsl:template>

<!--   Integer-->	
<xsl:template match="INTVersion" name="INTVersion">
	    
    <!--   -->	
  <fo:block font-family="Times" font-size="10pt"
	    space-before="4pt"				
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_INTVersion_header</xsl:with-param> </xsl:call-template>			
  </fo:block>

         <!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	<xsl:value-of select="."/>
  </fo:block>

</xsl:template>
	<!--  CertStatus -->
<xsl:template match="CertStatus" name="CertStatus">
   <fo:block font-family="Arial" font-size="12pt"                              
	space-before="10pt"
	space-after="5pt"
	space-before.precedence="0"
	space-after.precedence="3"
	>
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertStatus_header</xsl:with-param> </xsl:call-template> 


	<xsl:for-each select="./good">  
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertStatus_good</xsl:with-param> </xsl:call-template>
      	</xsl:for-each>

	<xsl:for-each select="./revoked">  
		<xsl:call-template name="RevokedInfo"/>
      	</xsl:for-each>

	<xsl:for-each select="./unknown">  
		<xsl:call-template name="UnknownInfo"/>
      	</xsl:for-each>



   </fo:block>
</xsl:template>


	<!--  RevokedInfo -->
<xsl:template match="RevokedInfo" name="RevokedInfo">

 	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevokedInfo_header</xsl:with-param> </xsl:call-template> 

	<xsl:for-each select="./revocationTime">  
		<xsl:call-template name="GeneralizedTime"/>
      	</xsl:for-each>

      <xsl:for-each select="./revocationReason">  
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	   <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_RevokedInfo_revocationReason</xsl:with-param> </xsl:call-template>
	   <xsl:call-template name="CRLReason"/>
        </fo:block>
       </xsl:for-each>
</xsl:template>	



	<!--  ResponderID -->
<xsl:template match="ResponderID" name="ResponderID">
	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponderID_header</xsl:with-param> </xsl:call-template>

          <xsl:for-each select="./byName">  
	 	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponderID_byName</xsl:with-param> </xsl:call-template>
		<fo:block font-family="Courier New" font-size="10pt"                                
		    border-style="solid"
		    padding="3pt"
		    >
			<xsl:call-template name="Name"/>
		</fo:block>	
          </xsl:for-each>

          <xsl:for-each select="./byKey">  
	 	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ResponderID_byKey</xsl:with-param> </xsl:call-template>
		<fo:block font-family="Courier New" font-size="10pt"                                
		    border-style="solid"
		    padding="3pt"
		    >
		<xsl:call-template name="KeyHash"/>
		</fo:block>	
          </xsl:for-each>

	</fo:block>
</xsl:template>


	<!--  KeyHash -->
<xsl:template match="KeyHash" name="KeyHash">

	<fo:block font-family="Times" font-size="10pt"                                
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	  <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_KeyHash_header</xsl:with-param> </xsl:call-template>
	</fo:block>

        <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"                        
	    padding="3pt"
	    >
	    <xsl:value-of select="."/>
	</fo:block>
</xsl:template>


<xsl:template match="DigestInfo" name="DigestInfo">

 	  <xsl:for-each select="./digestAlgorithm">  
		<xsl:call-template name="DigestAlgorithmIdentifier"/>
	  </xsl:for-each>

 	  <xsl:for-each select="./digest">  
		<xsl:call-template name="Digest"/>
	  </xsl:for-each>
</xsl:template>


	<!--  Digest -->
<xsl:template match="Digest" name="Digest">

	<!--    -->
  <fo:block font-family="Times" font-size="10pt"				
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_Digest_header</xsl:with-param> </xsl:call-template>                                      <!--  -->
  </fo:block>
  <fo:block font-family="Courier New" font-size="10pt"                              
	    border-style="solid"
	    padding="3pt"
	    >
	<xsl:value-of select="."/>
  </fo:block>
</xsl:template>


<xsl:template match="CertPolicyId" name="CertPolicyId">
	<!--  -->
    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertPolicyId_header</xsl:with-param> </xsl:call-template> 
    <xsl:call-template name="printOID"/>
</xsl:template>


<xsl:template match="PathProcInput" name="PathProcInput">
    <fo:block font-family="Times" font-size="12pt"
	      space-before="10pt"
	      space-after="5pt"
	      space-before.precedence="0"
	      space-after.precedence="3"                
	      keep-with-next="always"
	      >  
	      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PathProcInput_acceptablePolicySet</xsl:with-param> </xsl:call-template>
    </fo:block>

    <fo:block border-style="solid" padding="3pt">
      <xsl:for-each select="./acceptablePolicySet/*">  
	<xsl:call-template name="PolicyInformation"/>
      </xsl:for-each>
    </fo:block>

    <xsl:choose>
	<xsl:when test='./inhibitPolicyMapping/true'>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PathProcInput_inhibitPolicyMapping_true</xsl:with-param> </xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PathProcInput_inhibitPolicyMapping_false</xsl:with-param> </xsl:call-template>
	</xsl:otherwise>
    </xsl:choose>

    <xsl:choose>
	<xsl:when test='./explicitPolicyReqd/true'>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PathProcInput_explicitPolicyReqd_true</xsl:with-param> </xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_PathProcInput_explicitPolicyReqd_false</xsl:with-param> </xsl:call-template>
	</xsl:otherwise>
    </xsl:choose>

</xsl:template>

	<!--  ESSCertID -->
<xsl:template match="ESSCertID" name="ESSCertID">

      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ESSCertID_header</xsl:with-param> </xsl:call-template>				
      </fo:block>


      <xsl:for-each select="./certHash">  
	<xsl:call-template name="CertHash"/>
      </xsl:for-each>

      <xsl:for-each select="./issuerSerial">  
	<xsl:call-template name="IssuerSerial"/>
      </xsl:for-each>

</xsl:template>

<xsl:template match="ESSCertIDv2" name="ESSCertIDv2">

      <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_ESSCertID_header</xsl:with-param> </xsl:call-template>				
      </fo:block>

      <xsl:for-each select="./hashAlgorithm">  
	<xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertID_hashAlgorithm</xsl:with-param> </xsl:call-template>				
	<xsl:call-template name="AlgorithmIdentifier"/>
      </xsl:for-each>

      <xsl:for-each select="./certHash">  
	<xsl:call-template name="CertHash"/>
      </xsl:for-each>

      <xsl:for-each select="./issuerSerial">  
	<xsl:call-template name="IssuerSerial"/>
      </xsl:for-each>

</xsl:template>

	<!--  CertHash -->
<xsl:template match="certHash" name="CertHash">

  <fo:block font-family="Times" font-size="10pt"                        
	    space-before="6pt"
	    space-after="3pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >
	    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_CertHash_header</xsl:with-param> </xsl:call-template>				
  </fo:block>

  <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	    <xsl:value-of select="."/>
  </fo:block>
</xsl:template>



	<!--  IssuerSerial -->
<xsl:template match="issuerSerial" name="IssuerSerial">

  <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

    <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuerSerial_issuer</xsl:with-param> </xsl:call-template>
  </fo:block>

	<!--   -->
  <fo:block font-family="Courier New" font-size="10pt"
    border-style="solid"
    padding="3pt"
    >
    <xsl:for-each select="./issuer">  
	<xsl:call-template name="GeneralNames"/>
    </xsl:for-each>
   </fo:block>

    <xsl:for-each select="./serialNumber">  
	<xsl:call-template name="CertificateSerialNumber"/>
    </xsl:for-each>


	<!--   -->
     <xsl:for-each select="./issuerUID">  
    	<!--   -->
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_IssuerSerial_issuerUID</xsl:with-param> </xsl:call-template>
     </fo:block>
	<xsl:call-template name="UniqueIdentifier"/>
    </xsl:for-each>


</xsl:template>

	<!--  SMIMECapabilities -->
<xsl:template match="SMIMECapabilities" name="SMIMECapabilities">

     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SMIMECapabilities_header</xsl:with-param> </xsl:call-template>
     </fo:block>

     <xsl:for-each select="./*">  
	<xsl:call-template name="SMIMECapability"/>
    </xsl:for-each>

</xsl:template>



	<!--  SMIMECapability -->
<xsl:template match="SMIMECapability" name="SMIMECapability">

     <xsl:for-each select="./capabilityID">  
	<xsl:call-template name="printOID"/>
     </xsl:for-each>

    	<!--  -->
    <xsl:for-each select="./*">  
     <fo:block font-family="Times" font-size="10pt"			
	    space-before="4pt"
	    space-after="2pt"
	    space-before.precedence="0"
	    space-after.precedence="3"
	    keep-with-next="always"
	    >

      <xsl:call-template name="printTEXT"> <xsl:with-param name="textID">local_SMIMECapability_parameters</xsl:with-param> </xsl:call-template>
     </fo:block>

     <fo:block font-family="Courier New" font-size="10pt"
	    border-style="solid"
	    padding="3pt"
	    >
	    <xsl:apply-templates select="."/>
     </fo:block>
    </xsl:for-each>

</xsl:template>




<xsl:template name="longWord">
  <xsl:param name="val"/>
  <xsl:param name="startpos"/>
	<xsl:variable name="linelen" select="93"/>
	<xsl:value-of select="substring($val,1,$linelen -$startpos)"/>
	<xsl:if test="substring($val,1+$linelen* 1-$startpos,$linelen) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 1-$startpos,$linelen)"/>
	<xsl:if test="substring($val,1+94* 2-$startpos,94) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 2-$startpos,$linelen)"/>
  	<xsl:if test="substring($val,1+$linelen* 3-$startpos,$linelen) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 3-$startpos,$linelen)"/>
	<xsl:if test="substring($val,1+$linelen* 4-$startpos,$linelen) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 4-$startpos,$linelen)"/>
	<xsl:if test="substring($val,1+$linelen* 5-$startpos,$linelen) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 5-$startpos,$linelen)"/>
	<xsl:if test="substring($val,1+$linelen* 6-$startpos,$linelen) != ''"><xsl:text> </xsl:text></xsl:if>

	<xsl:value-of select="substring($val,1+$linelen* 6-$startpos,1000)"/>
</xsl:template>





<xsl:template name="split">
  <xsl:param name="val"/>
<!--  <fo:block keep-with-next="always">-->
	<xsl:value-of select="substring($val,1+64* 0,64)"/>
	<xsl:if test="substring($val,1+64* 1,64) != ''">\</xsl:if>
<!--  </fo:block> -->

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 1,64)"/>
	<xsl:if test="substring($val,1+64* 2,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 2,64)"/>
  	<xsl:if test="substring($val,1+64* 3,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 3,64)"/>
	<xsl:if test="substring($val,1+64* 4,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 4,64)"/>
	<xsl:if test="substring($val,1+64* 5,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 5,64)"/>
	<xsl:if test="substring($val,1+64* 6,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 6,64)"/>
	<xsl:if test="substring($val,1+64* 7,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 7,64)"/>
	<xsl:if test="substring($val,1+64* 8,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 8,64)"/>
	<xsl:if test="substring($val,1+64* 9,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64* 9,64)"/>
	<xsl:if test="substring($val,1+64* 10,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*10,64)"/>
	<xsl:if test="substring($val,1+64* 11,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*11,64)"/>
	<xsl:if test="substring($val,1+64* 12,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*12,64)"/>
	<xsl:if test="substring($val,1+64* 13,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*13,64)"/>
	<xsl:if test="substring($val,1+64* 14,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*14,64)"/>
	<xsl:if test="substring($val,1+64* 15,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*15,64)"/>
	<xsl:if test="substring($val,1+64* 16,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*16,64)"/>
	<xsl:if test="substring($val,1+64* 17,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*17,64)"/>
	<xsl:if test="substring($val,1+64* 18,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*18,64)"/>
	<xsl:if test="substring($val,1+64* 19,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block keep-with-next="always">
	<xsl:value-of select="substring($val,1+64*19,64)"/>
	<xsl:if test="substring($val,1+64* 20,64) != ''">\</xsl:if>
  </fo:block>

  <fo:block><xsl:value-of select="substring($val,1+64*20,64)"/></fo:block>
</xsl:template>



</xsl:stylesheet>
