/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

/*
 * \file $RCSfile$
 * \version $Revision: 247727 $
 * \date $Date:: 2022-10-06 23:51:56 +0300#$
 * \author $Author: sagafyin $
 * \brief ,       
 *     . 
 */

#if !defined _SUPPORT_SUP_SYSE_H
#define _SUPPORT_SUP_SYSE_H

#include "reader/support.h"

#define SUPSYSE_FLAG_BLOCK_GENERAL 0
#define SUPSYSE_FLAG_GENERAL_ADD_LIBRARY 0
#define SUPSYSE_FLAG_GENERAL_VERSION_1 1
#define SUPSYSE_FLAG_GENERAL_SUID 1
#define SUPSYSE_FLAG_GENERAL_VERSION_2 2

//       pcsc-lite
#define SUPSYSE_NICKNAME_LENGTH 0xFF

#define SUPSYSE_REGISTER_FLAG_FAILED 0x1
#define SUPSYSE_REGISTER_FLAG_DISABLED 0x2
#define SUPSYSE_REGISTER_FLAG_NOCONNECT 0x4
#define SUPSYSE_REGISTER_FLAG_REREAD 0x8
#define SUPSYSE_REGISTER_FLAG_PNPGROUP 0x10
#define SUPSYSE_REGISTER_FLAG_FORCE_REREAD 0x20
#define SUPSYSE_REGISTER_FLAG_CACHE 0x40

/*     */
#define SUPSYSE_MEDIA_ICON_EMPTY 0
/*       */
#define SUPSYSE_MEDIA_ICON_INSERTED 1
/*      ,   */
#define SUPSYSE_MEDIA_ICON_ERROR 2
/*      ,    */
#define SUPSYSE_MEDIA_ICON_UNKNOWN 3
/*      ,  */
#define SUPSYSE_MEDIA_ICON_BLOCKED 4

typedef TCHAR TSupSysNickname[SUPSYSE_NICKNAME_LENGTH + 1];
struct TSupSysEContext_;
typedef struct TSupSysEContext_ TSupSysEContext;
struct TSupSysEList_;
typedef struct TSupSysEList_ TSupSysEList;
struct TSupSysEFind_;
typedef struct TSupSysEFind_ TSupSysEFind;
struct TSupSysEHandle_;
typedef struct TSupSysEHandle_ TSupSysEHandle;
struct TSupSysFindInfo_;
typedef struct TSupSysFindInfo_ TSupSysFindInfo;

typedef int(*TSupSysFindValidFun)(const TSupSysFindInfo *add_info, const TSupSysEContext *item);
typedef int(*TSupSysFindValidFunCC)(void * call_ctx, const TSupSysFindInfo *add_info, const TSupSysEContext *item);

#if defined( __cplusplus )
extern "C" {
#endif

/*  . */
DWORD supsys_nickname( 
    const TSupSysEContext *context, TSupSysNickname nickname );

/*  . */
DWORD supsys_name( 
    const TSupSysEContext *context, size_t *length, TCHAR *name );

/*   ,    . */
DWORD supsys_register_name( 
    const TSupSysEContext *context, size_t *length, TCHAR *name );

DWORD supsys_applet_term(
    const TSupSysEContext * context, TSupSysNickname applet_term);

/*    . */
DWORD supsys_icon( 
    const TSupSysEContext *context, TSupIconHandle *icon_handle );

/*    . */
DWORD supsys_icons( 
    const TSupSysEContext *context, TSupIcon *icons, int iconnum );

/*    . */
DWORD supsys_find_open( 
    const TSupSysEList *list, TSupSysEFind **context );

/*    . */
DWORD supsys_find_open_ext(
    const TSupSysEList *list, TSupSysEFind **context, TSupSysFindInfo *add_info,
    TSupSysFindValidFun valid_fun);

/*       CallCtx. */
DWORD supsys_find_open_ext_cc(
    const TSupSysEList *list, TSupSysEFind **context, TSupSysFindInfo *add_info,
    TSupSysFindValidFunCC valid_fun_cc);

/*    . */
DWORD supsys_find_next( 
    TSupSysEFind *context, TSupSysEContext **ctx );

/*    . */
DWORD supsys_find_next_cc(
    void * call_ctx, TSupSysEFind *context, TSupSysEContext **ctx);

/*      . */
DWORD supsys_find_nickname(
    const TSupSysEList *list, TSupSysNickname nickname,
    TSupSysEContext **ctx);

/*    . */
DWORD supsys_connect_current( 
    const TSupSysEContext *context, size_t *length, TCHAR *name );

/*  atr  . */
DWORD supsys_atr_current(
    const TSupSysEContext *context, BYTE* atr, size_t *length);

/*  mask  . */
DWORD supsys_mask_current(
    const TSupSysEContext *context, BYTE* mask, size_t *length);


/* . */
DWORD supsys_connect( 
    TSupSysEContext *context );

/* . */
DWORD supsys_disconnect( 
    TSupSysEContext *context );

/*    . */
DWORD supsys_parse_internal_name( 
    const TSupSysEList *list, const TCHAR *name, TSupSysEContext **context );

/*    . */
DWORD supsys_find_close( TSupSysEFind *context );

/*   HANDLE  . */
DWORD supsys_context_free( TSupSysEContext *ctx ); 

/*    . */
DWORD supsys_context_dup( 
    const TSupSysEContext *src, TSupSysEContext **dest );

/*  /  . */
DWORD supsys_enable( 
    TSupSysEContext *ctx, const TCHAR *ssconnect, const TCHAR *name,
    int enabling );

/*    . */
DWORD supsys_flags(
    const TSupSysEContext *context, size_t type, size_t *quant,
    unsigned char *flags );

/*    . */
DWORD supsys_flag( 
    const TSupSysEContext *context, size_t type, size_t num,
    int *flag );

/*   ,  ,     ,
  flag  def_flag_value*/
DWORD supsys_flag_ex(
    const TSupSysEContext *context,
    size_t type,
    size_t num,
    int def_flag_value,
    int *flag);

/*     . */
DWORD supsys_unregister_all( TSupSysEList *list, 
    int unload );

/*     . */
DWORD supsys_register_all_ext( 
    TSupSysEList *list, unsigned flags );

/*     . */
DWORD supsys_register_all( 
    TSupSysEList *list );

/*     . */
DWORD supsys_register_one(
    TSupSysEList *list, const TCHAR *reader);

DWORD supsys_add_ctx_to_list(
    TSupSysEList *list, TSupSysEContext *context);

DWORD supsys_clear_check_list(
    const TSupSysEList* list);

DWORD supsys_add_ctx_to_check_list(
    const TSupSysEList* list, TSupSysEContext *context);

DWORD supsys_get_item_marks(
    const TSupSysEList* list, unsigned short * mark_out);

DWORD supsys_list_notificator( 
    const TSupSysEList *list, TSupRegNotificator **notificator );

/* ,   supsys */
DWORD support_default_internal_register_name( 
    const TSupSysEContext *context, size_t *length, TCHAR *name, 
    const TCHAR *ssconnect );
/*    */
DWORD supsys_load_connect(TSupSysEList *list,
	unsigned registration_flags,
	BOOL disabled_flag,
	BOOL no_register_flag,
	const TCHAR *dll_name,
	const TCHAR *nickname,
	const TCHAR *path2connect,
	const TCHAR *connect,
	const TCHAR *in_group_name);

DWORD supsys_company(const TSupSysEContext *context, size_t *length, TCHAR *company);

#if defined( __cplusplus )
}
#endif

#endif /* _SUPPORT_SUP_SYSE_H */
