/*
 * Copyright(C) 2000  
 *
 *    , 
 *    .
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *      .
 */

#if !defined( _READER_FAT12_FAT12INT_H )
#define _READER_FAT12_FAT12INT_H

#include <tchar.h>
#include "reader.kit/reader.h"
#include "os_specific.h"

#ifdef UNIX
#   define _POSIX_PTHREAD_SEMANTICS 1
#   include <dirent.h>
#endif /* UNIX */

#define DIR_NOTEXIST 0
#define DIR_EXIST 1
#define DIR_INVALID 2
#define DIR_WRONG_NAME 3

/*++++
 *     .
 ++++*/
static SUP_INLINE TCHAR fat12_convert( int c )
{
    if( c >= 'a' && c <= 'z' )
	return (TCHAR)c;
    if( c >= 'A' && c <= 'Z' )
	return (TCHAR)c;
    if( c >= '0' && c <= '9' )
	return (TCHAR)c;
    if( c == '-' )
	return (TCHAR)c;
    return (TCHAR)( ( (unsigned char)c ) % ( 'z' - 'a' + 1 ) + 'a' );
}

#if defined( __cplusplus )
extern "C" {
#endif

#if !defined( _RESOURCE )
/*+  . +*/
extern TSupResourceInstance FAT12_RESOURCE;
#else
#define FAT12_RESOURCE FAT12_DLL_INSTANCE
extern HINSTANCE FAT12_DLL_INSTANCE;
#endif /* !defined( _RESOURCE ) */

#define FAT12_FLAG_HDIMAGE 0x1

//    : ,   .    . register/unregister & dup/free
typedef enum {
    TCtxCreationType_registered,
    TCtxCreationType_duplicated
} TCtxCreationType;

/*   fat12,    f12def.c -   FLASH!*/
typedef struct {
    TCHAR *path_to_item;
    TCtxCreationType m_creation_type; //       
} TFat12GroupContext;

/*+       fat12. +*/
typedef struct {
    TCHAR *path; /*+  . 
	 A: "A",  B: "B",  removable  . +*/
#if defined _WIN32 
    HANDLE handle;
    DWORD access; /*!<    . */
    void * pSD; /* !<  SecurityDescriptor*/
    DWORD SecInfo; /* !<    SD*/
    size_t pSD_size; /* !<   SecurityDescriptor*/
#else
    FILE *handle;
#endif /* _WIN32 */
    BOOL    long_names; /* ,    */
    unsigned long volume_serial; /*   ? */
    TCHAR *volume_label;
    TCHAR *file_name; /*!<   . */
    TCHAR *folder;
    TCHAR *path_to_item;
    unsigned flags;
    int machine;
    TSupSysNickname nickname;
    TSupSysNickname connect;
    BOOL is_encrypted;
    TGenericMutex lock;
    BOOL locked;
    TSupSysNickname lock_name;
    BOOL must_check_connect;
} TFat12Context;

typedef struct TFat12FolderEnumNew_
{
    TCHAR *full_prefix;
    TCHAR prefix[10];
    unsigned num;
} TFat12FolderEnumNew;

#define SHARING_VIOLATION_TRIES 10

/*++++
 *           .
 ++++*/
DWORD fat12_os_error( void );
DWORD fat12_os_error_inside(void);

DWORD check_container_access_by_file(const TFat12Context *ctx, const TCHAR* folder, const TCHAR* file);

#if defined _WIN32
DWORD fat12_unique_form( unsigned long volume_serial, const TCHAR *vname,
    size_t *length, TCHAR *unique );
BOOL isCPdisk(TCHAR * name);
#endif	/* _WIN32 */

int fat12_is_dir_exist( const TCHAR *path );

DWORD fat12_volume_name(const TCHAR* path, TCHAR** name, unsigned long* serial);

DWORD hdimage_path_default(TCHAR **str, int machine, BOOL is_hsm);

static const TCHAR BASE_PATH_CFG[] = _TEXT("\\config\\KeyDevices");
static const TCHAR DEFAULT_CONNECT[] = _TEXT("Default");
static const TCHAR LONG_NAMES_KEY[] = _TEXT("long_names");
BOOL get_registry_long_names_flag(TCHAR *path);

typedef struct _FOLDER_ITEM {
    TCHAR * name;
    TCHAR * path;
    TCHAR * unique;
} FOLDER_ITEM;

/*      DIR*/
typedef struct TDirConnectEnum_
{
    FOLDER_ITEM * items;
    DWORD number;
    DWORD cur;
    TCHAR * full_buffer;
} TDirConnectEnum;

/*      DIR*/
DWORD get_items_from_registry(TSupSysComputeCheckMark compute_mark_func, unsigned short * change_mark,
    FOLDER_ITEM ** out_items, DWORD * out_items_number, TCHAR ** full_buffer, size_t * max_name_length);

#if defined( __cplusplus )
}
#endif

#endif /* !_READER_FAT12_FAT12INT_H */
