#ifndef SUPPORT_STRING_HPP
#define SUPPORT_STRING_HPP

#include <string>
#include <algorithm>

#include "reader/support.h"

#ifndef tstring
#ifdef UNICODE
typedef std::wstring tstring;
#else //UNICODE
typedef std::string tstring;
#endif //UNICODE
#endif //tstring

namespace cpro {

    //  ,     
    template <
	typename T, 
	typename charType = typename T::value_type, typename iterType = typename T::iterator
	/*, typename sizeType = typename T::size_type*/
    > 
    class StringZeroFiller
    {
    public:
	StringZeroFiller(const charType * str) : m_container(str) {}
	StringZeroFiller(const T & str) : m_container(str) {}
	StringZeroFiller() {}
	~StringZeroFiller() { fill_container_with_zeroes(); }
	const T & get() const { return m_container; }
	void clear() { fill_container_with_zeroes();  m_container.clear(); }
        void assign(const charType* first, const charType* last) {fill_container_with_zeroes();  m_container.assign(first, last);}
	//static const sizeType npos = T::npos;
    private:
	void fill_container_with_zeroes() {
	    for (iterType it = m_container.begin(); it != m_container.end(); ++it) {
		support_zero_memory(&(*it), sizeof(charType));
	    }
	}
	friend bool operator==(const StringZeroFiller & lhs, const StringZeroFiller & rhs) { return rhs.m_container == lhs.m_container; }
	friend bool operator!=(const StringZeroFiller & lhs, const StringZeroFiller & rhs) { return !(rhs == lhs); }

	T m_container;
    };
    typedef StringZeroFiller<std::string> string;
    typedef StringZeroFiller<std::wstring> wstring;
    
#ifdef UNICODE
    typedef wstring tstring;
#else //UNICODE
    typedef string tstring;
#endif //UNICODE

    template <typename T>
    inline std::string to_string(T param)
    {	
	std::string str;
	for (; param; param /= 10)
	    str += (char)('0' + param % 10);
	std::reverse(str.begin(), str.end());
	return str;
    }

    inline std::string to_string(const cpro::string & param)
    {
	return std::string(param.get().c_str());
    }
}

#endif // SUPPORT_STRING_HPP
