/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2010-2021 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 227363 $
 * \date $Date:: 2021-04-28 14:17:15 +0300#$
 * \author $Author: ivan $
 *
 * \brief      <sys/file.h>
 *
 */

#ifndef sup_file_h_
#define sup_file_h_

#include <sys/file.h>
#include "reader/support.h"
#include "reader/sup_errno.h"
#include "reader/sup_signal_safe.h"

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

#ifdef HAS_FLOCK
    SUPPORT_NOSIG(int, /* No prefix, see C99, 6.10.3, Exmpl. 5 */,
		flock, (int fildes, int operation),
		(fildes, operation),
		0 == ret,
		(EET_FTEXT(db_ctx, "%s(%d, %d) = %d fail %s(%d)"),
		SFUNC, fildes, operation,
		ret, SUP_STRERROR(serrno), serrno))
#endif // HAS_FLOCK

#ifdef __cplusplus
}
#endif // __cplusplus

#endif // sup_file_h_
