/* vim:set sw=4 ts=8 fileencoding=cp1251:::WINDOWS-1251[] */
#ifdef _WIN32
    #pragma setlocale("rus")
#endif
/*
 * Copyright(C) 2010-2014 -, 
 *
 *    , 
 *   -.
 *
 *        ,
 * ,    ,
 *     ,
 * ,      
 *     
 *     -.
 */

/*!
 * \file $RCSfile$
 * \version $Revision: 166578 $
 * \date $Date:: 2017-11-22 12:19:32 +0300#$
 * \author $Author: maxdm $
 *
 * \brief       .
 *
 * TODO:X -    KChanSck.c    ...
 */

#ifndef sup_errno_h_
#define sup_errno_h_

#ifdef UNIX
    #include <errno.h>
#endif
#include <string.h>

#include "reader/support.h"

#ifdef __cplusplus
extern "C" {
#endif

#if !defined UNIX
    #define SUP_ERRNO	    (WSAGetLastError())
    #define SUP_SETERRNO(e) (WSASetLastError(e))
    #define SUP_CASE_EAGAIN WSAEWOULDBLOCK
    #define SUP_CASE_EINPROGRESS WSAEINPROGRESS: case EWOULDBLOCK
    #define SUP_EWOULDBLOCK WSAEWOULDBLOCK
    #define SUP_EINTR       WSAEINTR
    #define SUP_EINPROGRESS WSAEINPROGRESS
    #define SUP_EALREADY    WSAEALREADY
    #define SUP_EISCONN     WSAEISCONN
    #define SUP_ENOTCONN    WSAENOTCONN
    #define SUP_ENOTSOCK    WSAENOTSOCK
    #define SUP_EINVAL	    WSAEINVAL

    // TODO:XX   strerror()  FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM)
    // FormatMessage(FORMAT_MESSAGE_FROM_SYSTEM|FORMAT_MESSAGE_IGNORE_INSERTS,
    // NULL, err, 0, (LPTSTR)&soap->errorstr,
    // sizeof(soap->errorstr)/sizeof(soap->errorstr[0]), NULL);
    //
    #pragma warning(disable: 4996)
    #define SUP_STRERROR(err)	_tcserror(err)
#else
    #define SUP_ERRNO	    (errno)
    #define SUP_SETERRNO(e) (errno = (e))
    #if defined EWOULDBLOCK && EWOULDBLOCK != EAGAIN
	#define SUP_CASE_EAGAIN EAGAIN: case EWOULDBLOCK
	#define SUP_EWOULDBLOCK EWOULDBLOCK
    #else
        #define SUP_CASE_EAGAIN EAGAIN
	#define SUP_EWOULDBLOCK EAGAIN
    #endif
    #define SUP_EINTR       EINTR
    #define SUP_EINPROGRESS EINPROGRESS
    #define SUP_EALREADY    EALREADY
    #define SUP_EISCONN     EISCONN
    #define SUP_ENOTCONN    ENOTCONN
    #define SUP_ENOTSOCK    ENOTSOCK
    #define SUP_EINVAL	    EINVAL

    //   Linux, strerror()    thread safe,
    //     :(
    #if !defined(CSP_LITE)
	const char *support_strerror(int errnum);
	//const wchar_t *support_wcserror(int); //   
	#define SUP_STRERROR(errnum)	support_strerror(errnum)
	#define strerror(errnum) SUP_STRERROR(errnum)
    #endif
#endif

#ifdef __cplusplus
}
#endif
#endif /* sup_errno_h_ */
