/*!
 * \file $RCSfile$
 * \version $Revision: 228662 $
 * \date $Date:: 2021-06-08 22:32:15 +0300#$
 * \author $Author: maxdm $
 *
 * \brief    <atltrace.h>   ATL Microsoft.
 *
 *          .
 *      ATL ,    :
 *  1)         ,    .
 *  2)      Release .
 *
 *  ATLTRACE  ATLTRACE2     
 *  _DEBUG    ATL    (void)0 
 * Release , ..     ,  
 *    .
 *
 *     CPTRACE  CPTRACE2,  
 *     ,    Release .
 *
 *  ,      <atltrace.h>,   
 *    ATL2, ..     <windows.h>.
 *    MFC  <afx.h>  
 *  <windows.h>.    :
 * "atltrace2.h"  <afx.h>     "atltrace2.inl"
 *   ATL    ,   
 * "atltrace2.inl"   "atltrace2.h",   
 * <atltrace.h>   .
 */

#ifndef _ATLTRACE2_H_INCLUDED
#define _ATLTRACE2_H_INCLUDED

#ifdef USE_CPTRACEB
#error cptraceb.lib is obsolete, use cptrace.lib instead
#endif //USE_CPTRACEB


//  USE_CPTRACE ,      
// CPTraceFileAndLineInfo(__FUNCTION__, __FILE__, __LINE__)   
//  ATLTRACE  ATLTRACE2.

//  USE_CPTRACE_IMPL ,    
// CPTraceFileAndLineInfo(__FUNCTION__, __FILE__, __LINE__)
//      cptrace.lib,  
//     ATL  atls.lib.

//  NOT_USE_ATLTRACE_H   ,     
//  <atltrace.h>       
//   ATLTRACE  ATLTRACE2   .

#define USE_CPTRACE

#ifdef USE_COMMON_MAPFILE_32_64
#define XDWORD_PTR DWORD
#define XDWORD_PTR_UINT unsigned int
#else //USE_COMMON_MAPFILE_32_64
#define XDWORD_PTR DWORD_PTR
#define XDWORD_PTR_UINT DWORD_PTR
#endif //USE_COMMON_MAPFILE_32_64

#ifndef USE_CPTRACE
//     ATLTRACE  ATLTRACE2,    ,
//   CPTRACE  CPTRACE2 - .
#define CPTRACE ATLTRACE
#define CPTRACE2 ATLTRACE2
#define DECLARE_CPTRACE_CATEGORY(name) DECLARE_TRACE_CATEGORY(name)
#define CPTraceGeneral	ATL::atlTraceGeneral
#define CPTraceSnapin	ATL::atlTraceSnapin
#else //USE_CPTRACE

#ifdef _DEBUG

//  _WIN64   ATLTRACE  (  ),
//   _WIN64      
// CPTraceModuleManager   Release,    Debug .
//         
//  atl.dll,      
// DLL,  activeds.dll.    .
#ifdef USE_COMMON_MAPFILE_32_64
//#define NOT_USE_ATLTRACE_H
#endif //USE_COMMON_MAPFILE_32_64

#endif //_DEBUG

#define USE_CPTRACE_IMPL

#ifdef NOT_USE_ATLTRACE_H
#define __ATLTRACE_H__ //  atltrace.h   .
#endif //NOT_USE_ATLTRACE_H

#ifdef _MSC_VER

#pragma comment(linker, "/include:?g_bCPTraceSettingsInited@@3_NA")

#endif //_MSC_VER

#ifdef NOT_USE_ATLTRACE_H
#pragma comment(lib, "atlsd_nobug.lib")
#pragma comment(linker, "/nodefaultlib:atlsd")
#endif //NOT_USE_ATLTRACE_H

#ifdef _DEBUG
//     ATLASSERT-   WebDbg.exe  DECLARE_DEBUGREPORTHOOK
// ,  WebDbg.exe  ,     ASSERT-   ()
//   DECLARE_NOUIASSERT    
#define DECLARE_DEBUGREPORTHOOK() ATL::CDebugReportHook _g_DebugReportHook;
#else //_DEBUG
#define DECLARE_DEBUGREPORTHOOK()
#endif //_DEBUG

//    CPTRACE   CPTraceFileAndLineInfo
#define CPTRACE2 ATL::CPTraceFileAndLineInfo(__FUNCTION__, __FILE__, __LINE__)
#define CPTRACE CPTRACE2

#ifdef USE_CPTRACE_IMPL
#define DECLARE_CPTRACE_CATEGORY(name) extern ATL::CPTraceCategory name;
#else //USE_CPTRACE_IMPL
#define DECLARE_CPTRACE_CATEGORY(name) DECLARE_TRACE_CATEGORY(name)
#define CPTraceGeneral	ATL::atlTraceGeneral
#define CPTraceSnapin	ATL::atlTraceSnapin
#endif //USE_CPTRACE_IMPL

#ifdef NOT_USE_ATLTRACE_H
//#define CTraceCategory CPTraceCategory
#define CPTraceCategory CTraceCategory
#define CCPTrace CTrace
#endif // NOT_USE_ATLTRACE_H

#if !defined UNIX
#include <basetsd.h>
#else
#include <wchar.h>
#endif	/* UNIX */

namespace ATL {

#ifdef USE_CPTRACE_IMPL

typedef enum CPTRACESTATUS
{
    CPTRACESTATUS_INHERIT, CPTRACESTATUS_ENABLED, CPTRACESTATUS_DISABLED
} CPTRACESTATUS;

// Declare a global instance of this class to automatically register a custom trace category at startup
class CPTraceCategory
{
public:
//  ,        LPCTSTR  .,
// ..        (   - MFC).

#ifdef UNICODE
    explicit CPTraceCategory( const wchar_t *pszCategoryName, unsigned int nStartingLevel = 0 ) throw();
#else //UNICODE
    explicit CPTraceCategory( const char *pszCategoryName, unsigned int nStartingLevel = 0 ) throw();
#endif //UNICODE

    unsigned int GetLevel() const throw();
    void SetLevel( unsigned int nLevel ) throw();
    CPTRACESTATUS GetStatus() const throw();
    void SetStatus( CPTRACESTATUS eStatus) throw();

    operator XDWORD_PTR_UINT () const throw();

public:
    XDWORD_PTR_UINT m_dwCategory;
};

#endif //USE_CPTRACE_IMPL

class CPTraceFileAndLineInfo
{
public:
    CPTraceFileAndLineInfo(const char *pszTypeName, const char *pszFileName, int nLineNo);
    CPTraceFileAndLineInfo(const char *pszFileName, int nLineNo);
    void __cdecl operator()(DWORD_PTR dwCategory, UINT32 nLevel, const char *pszFmt, ...) const;
    void __cdecl operator()(DWORD_PTR dwCategory, UINT32 nLevel, const wchar_t *pszFmt, ...) const;
    void __cdecl operator()(const char *pszFmt, ...) const;
    void __cdecl operator()(const wchar_t *pszFmt, ...) const;
private:
    const char *cut_filename_add_typeinfo(const char *pszTypeName, const char *pszFileName);
    const char *cut_filename(const char *pszFileName);

    /* unimplemented */
    CPTraceFileAndLineInfo &__cdecl operator=(const CPTraceFileAndLineInfo &right);
    CPTraceFileAndLineInfo(const CPTraceFileAndLineInfo &source);

    const char *m_pszFileName;
    int m_nLineNo;
    char m_filepart[260];
};

#ifdef USE_CPTRACE_IMPL
// Declare a global instance of this class to automatically register a custom trace category at startup
DECLARE_CPTRACE_CATEGORY(CPTraceGeneral);
DECLARE_CPTRACE_CATEGORY(CPTraceSnapin);
#endif //USE_CPTRACE_IMPL

} // namespace ATL

#endif //USE_CPTRACE

#ifdef NOT_USE_ATLTRACE_H
namespace ATL {
//   ,     atltrace.h

DECLARE_CPTRACE_CATEGORY( atlTraceGeneral )
DECLARE_CPTRACE_CATEGORY( atlTraceCOM )
DECLARE_CPTRACE_CATEGORY( atlTraceQI )
DECLARE_CPTRACE_CATEGORY( atlTraceRegistrar )
DECLARE_CPTRACE_CATEGORY( atlTraceRefcount )
DECLARE_CPTRACE_CATEGORY( atlTraceWindowing )
DECLARE_CPTRACE_CATEGORY( atlTraceControls )
DECLARE_CPTRACE_CATEGORY( atlTraceHosting )
DECLARE_CPTRACE_CATEGORY( atlTraceDBClient )
DECLARE_CPTRACE_CATEGORY( atlTraceDBProvider )
DECLARE_CPTRACE_CATEGORY( atlTraceSnapin )
DECLARE_CPTRACE_CATEGORY( atlTraceNotImpl )
DECLARE_CPTRACE_CATEGORY( atlTraceAllocation )
DECLARE_CPTRACE_CATEGORY( atlTraceException )
DECLARE_CPTRACE_CATEGORY( atlTraceTime )
DECLARE_CPTRACE_CATEGORY( atlTraceCache )
DECLARE_CPTRACE_CATEGORY( atlTraceStencil )
DECLARE_CPTRACE_CATEGORY( atlTraceString )
DECLARE_CPTRACE_CATEGORY( atlTraceMap )
DECLARE_CPTRACE_CATEGORY( atlTraceUtil )
DECLARE_CPTRACE_CATEGORY( atlTraceSecurity )
DECLARE_CPTRACE_CATEGORY( atlTraceSync )
DECLARE_CPTRACE_CATEGORY( atlTraceISAPI )

// atlTraceUser categories are no longer needed.  Just declare your own trace category using CTraceCategory.
DECLARE_CPTRACE_CATEGORY( atlTraceUser )
DECLARE_CPTRACE_CATEGORY( atlTraceUser2 )
DECLARE_CPTRACE_CATEGORY( atlTraceUser3 )
DECLARE_CPTRACE_CATEGORY( atlTraceUser4 )

#pragma deprecated( atlTraceUser )
#pragma deprecated( atlTraceUser2 )
#pragma deprecated( atlTraceUser3 )
#pragma deprecated( atlTraceUser4 )
} // namespace ATL

#define ATLTRACENOTIMPL(funcname) __pragma(warning(push)) \
    __pragma(warning(disable: 4127)) \
    do { ATLTRACE(ATL::atlTraceNotImpl, 0, \
    _TEXT("ATL: %s not implemented.\n"), funcname); \
    return E_NOTIMPL; \
    } while(0) \
    __pragma(warning(pop))

#endif //NOT_USE_ATLTRACE_H

#include "atldef2.h"

//  ,    <atltrace.h>, ..  
//   <windows.h>.    MFC  <afx.h>  
//  <windows.h>.    :
// "atltrace2.h"  <afx.h>     "atltrace2.inl"
//            
// __ZN3ATL22CPTraceFileAndLineInfoC1EPKcS2_i

#if defined DEBUG && defined DARWIN
#include "tchar.h"
#include "atltrace2.inl"
#endif

#endif // _ATLTRACE2_H_INCLUDED
