#ifndef __CPCA20_USER_INFO_H__
#define __CPCA20_USER_INFO_H__
#include"SecureBuffer.h"
#include<string>
#include<set>
#include<vector>

#define UR20_DISP_NEW 3
#define UR20_DISP_ACCEPTED 4
#define UR20_DISP_REJECTED 5
#define UR20_DISP_UNDER_SUBMISSION 6
#define UR20_DISP_COMPLETED 7
#define UR20_DISP_APPROVED 8
#define UR20_DISP_ERROR 9

class CPCA20UserField
{
    public:
        //       DN
        std::string name;
        std::string LocalizedName;
        std::string oid;
        std::string value;
        bool ProhibitAnyValue;
        bool ProhibitChange;
        bool ProhibitEmpty;
        long maxlen;
        std::string DefaultValue;
        std::vector<std::string> SettingsValues;

        CPCA20UserField() :
            ProhibitAnyValue( false ),
            ProhibitChange( false ),
            ProhibitEmpty( false ),
            maxlen( -1 )
        {
        };
};

typedef std::vector<CPCA20UserField> CPCA20UserData;

class CPCA20UserFields
{
    public:
        CPCA20UserFields() : sbPassword(0), status(0) {}
        ~CPCA20UserFields() { delete sbPassword; }

        //      
        std::string TokenID;
        CSecurePin * sbPassword;
        unsigned int status; //    1
        std::string RegRequestID;

        CPCA20UserData fields;
        int check_field_name( std::string const& fieldName )
        {
            for ( size_t i = 0; i < fields.size(); i++ )
            {
                if ( fieldName == fields[i].name )
                { return ( int ) i; }
            }

            return -1;
        }
};
#endif
