/*
 * Copyright (C) 1997-2003 by Objective Systems, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Objective Systems, Inc.
 *
 * PROPRIETARY NOTICE
 *
 * This software is an unpublished work subject to a confidentiality agreement
 * and is protected by copyright and trade secret law.  Unauthorized copying,
 * redistribution or other use of this work is prohibited.
 *
 * The above notice of copyright on this source code product does not indicate
 * any actual or intended publication of such source code.
 *
 *****************************************************************************/

/**
 * @file asn1XerCTypes.h
 */

#ifndef _ASN1XERCTYPES_H_
#define _ASN1XERCTYPES_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>
#include <stdlib.h>
#include <setjmp.h>

#include "asn1xer.h"
#include "csaxParser.h"

typedef void (*ASN1XERStartElementHandler)(void *userData,
                                           ASN1Const XMLCHAR *name,
                                           ASN1Const XMLCHAR **atts);

typedef void (*ASN1XEREndElementHandler)(void *userData,
                                         ASN1Const XMLCHAR *name);

/* s is not 0 terminated. */
typedef void (*ASN1XERCharacterHandler)(void *userData,
                                        ASN1Const XMLCHAR *s,
                                        int len);

typedef struct ASN1SAXCDecodeHandlerBase {
   ASN1XERStartElementHandler mpStartElement;
   ASN1XEREndElementHandler mpEndElement;
   ASN1XERCharacterHandler mpCharacters;

   ASN1CTXT* mpCtxt;
   ASN1ConstCharPtr mpTypeName;
   ASN1XERState mCurrState;
   int mLevel, mStartLevel;
} ASN1SAXCDecodeHandlerBase;

#define ISCOMPLETE(e) (e->mSaxBase.mLevel == e->mSaxBase.mStartLevel)

#define ASN1SAXCTRY(pctxt,stat) \
if ((stat = setjmp((pctxt)->jmpMark)) == 0) 

#define ASN1SAXCTHROW(pctxt,stat) do { LOG_ASN1ERR ((pctxt), stat); \
longjmp((pctxt)->jmpMark, stat); } while (0)

#define ASN1SAXCCATCH else 

#define STRX(pctxt,pWideStr) xerTextToCStr ((pctxt), (pWideStr))

#if defined (XML_UNICODE) && defined(XML_UNICODE_WCHAR_T)
#define LSTRX(pctxt,pLStr)   xerTextToCStr ((pctxt), (pLStr))
#else
#define LSTRX(pctxt,pLStr)   \
strcpy ((char*)ASN1MALLOC (pctxt, strlen (pLStr) + 1), (pLStr))
#endif

#define XERCDIAG1(a)   RTDIAG1(a)
#define XERCDIAG2(a,b) RTDIAG2(a,b)

/* RTDIAG1/RTDIAG2 аккуратно описаны в rtsrc/asntypes.h
 * XERCDIAG3 -- местная находка
 */
#ifdef _TRACE
#define XERCDIAG3(a,b,c) do { \
void* p = (void*)b; \
RTDIAG3(a,p,c); \
ASN1MEMFREEPTR(pctxt,p); \
} while (0)
#else
#define XERCDIAG3(a,b,c)
#endif	/* _TRACE */

#ifndef _COMPACT
#define DECLARE_NON_COMPACT_VAR(type,var) type var
#else
#define DECLARE_NON_COMPACT_VAR(type,var)
#endif

//EXTERNXER int getXerXmlFactory (IXMLFactory** factory);

#ifdef __cplusplus
}
#endif
#endif /* _ASN1XERCTYPES_H_ */
