/*
 * Copyright (C) 1997-2003 by Objective Systems, Inc.
 *
 * This software is furnished under a license and may be used and copied
 * only in accordance with the terms of such license and with the
 * inclusion of the above copyright notice. This software or any other
 * copies thereof may not be provided or otherwise made available to any
 * other person. No title to and ownership of the software is hereby
 * transferred.
 *
 * The information in this software is subject to change without notice
 * and should not be construed as a commitment by Objective Systems, Inc.
 *
 * PROPRIETARY NOTICE
 *
 * This software is an unpublished work subject to a confidentiality agreement
 * and is protected by copyright and trade secret law.  Unauthorized copying,
 * redistribution or other use of this work is prohibited.
 *
 * The above notice of copyright on this source code product does not indicate
 * any actual or intended publication of such source code.
 *
 *****************************************************************************/

/** 
 * @file rtctype.h 
 */
#ifndef _RTCTYPE_H_
#define _RTCTYPE_H_

#include "asn1type.h"

/* Ctype module constants */

#define  OS_CTYPE_UPPER  0x1
#define  OS_CTYPE_LOWER  0x2
#define  OS_CTYPE_NUMBER 0x4
#define  OS_CTYPE_SPACE  0x8
#define  OS_CTYPE_PUNCT  0x10
#define  OS_CTYPE_CTRL   0x20
#define  OS_CTYPE_HEX    0x40
#define  OS_CTYPE_BLANK  0x80

/* Ctype substitution macros */

#define  OS_ISALPHA(c) \
(rtCtypeTable[(unsigned char)(c)]&(OS_CTYPE_UPPER|OS_CTYPE_LOWER))
#define  OS_ISUPPER(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_UPPER)
#define  OS_ISLOWER(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_LOWER)
#define  OS_ISDIGIT(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_NUMBER)
#define  OS_ISXDIGIT(c) \
(rtCtypeTable[(unsigned char)(c)]&(OS_CTYPE_HEX|OS_CTYPE_NUMBER))
#define  OS_ISSPACE(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_SPACE)
#define  OS_ISPUNCT(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_PUNCT)
#define  OS_ISALNUM(c)  \
(rtCtypeTable[(unsigned char)(c)]&(OS_CTYPE_UPPER|OS_CTYPE_LOWER|OS_CTYPE_NUMBER))
#define  OS_ISPRINT(c)  \
(rtCtypeTable[(unsigned char)(c)]& \
(OS_CTYPE_PUNCT|OS_CTYPE_UPPER|OS_CTYPE_LOWER|OS_CTYPE_NUMBER|OS_CTYPE_BLANK))
#define  OS_ISGRAPH(c)  \
(rtCtypeTable[(unsigned char)(c)]& \
(OS_CTYPE_PUNCT|OS_CTYPE_UPPER|OS_CTYPE_LOWER|OS_CTYPE_NUMBER))
#define  OS_ISCNTRL(c)  \
(rtCtypeTable[(unsigned char)(c)]&OS_CTYPE_CTRL)

#define  OS_TOLOWER(c) (OS_ISUPPER(c) ? (c) - 'A' + 'a' : (c))
#define  OS_TOUPPER(c) (OS_ISLOWER(c) ? (c) - 'a' + 'A' : (c))

#ifdef __cplusplus
extern "C" {
#endif

/* ctype module table */

extern const ASN1OCTET rtCtypeTable[256];

#ifdef USEASN1RTDLL
    #include "rtctype.c"
#endif

#ifdef __cplusplus
}
#endif

#endif /* _RTCTYPE_H_ */

